------------------------------------------------------------------------------
-- Introduction, rescue serfs
------------------------------------------------------------------------------
function start1stChapter()

	Logic.SetShareExplorationWithPlayerFlag(1,7,1)

	AddDefeatEntity("P1_Headquarter")
	AddDefeatEntity("P3_EastVillage_HQ")

	CreateChestOpener("Ari")
	CreateChestOpener("Salim")
	CreateChestOpener("Dario")
	CreateChestOpener("Pilgrim")
	CreateChestOpener("Helias")
	CreateChestOpener("Drake")
	CreateChestOpener("Yuki")
	StartChestQuest()
	
	firstAttack  = true
	
	-- Setup AI
	CreatePlayer2()
	CreatePlayer3()
	--CreatePlayer5()

	-- Spawn troops
	CreateArmyFirstAttack()
	CreateArmyPlayer()
	CreateArmyP3Defense()
	
	-- briefing
	CreateBriefingPrelude()

	CreateQuestRescueSerfs()

	-- Start winter after some time
	--CreateQuestWinter()


	CreateNPCHeadquarters()

end
function end1stChapter()
	
	ResolveBriefing(briefingPreludeRescueSerfs)
	
	start2ndChapter()

end
------------------------------------------------------------------------------
-- Spoke with east village npc
------------------------------------------------------------------------------
function start2ndChapter()
	
	--CreateArmyEastVillageAttack()
	--CreateArmyGraveYardAttack()
	--CreateArmyMerchantAttack()
	--CreateArmyRuinsAttack()
	CreateArmyAttackers()
	
	local bombNPC = {}
	bombNPC.name = "bombriderNPC"
	bombNPC.callback = createBombBriefing
	
	CreateNPC(bombNPC)
	
	CreateNPCEastVillage()

	start1stSubChapter()
	
end
function end2ndChapter()

	ResolveBriefing(NPCHeadquartersBriefingShowNPC)
	
	-- remove from diplomacy window
	SetPlayerName(3)
	
	-- east village joins player
	Logic.ChangeAllEntitiesPlayerID(3, 1)
	
	start3rdChapter()
				
end

------------------------------------------------------------------------------
-- wait for winter
------------------------------------------------------------------------------
function start3rdChapter()

	firstAttack = false
	FirstAttackWest.AutoDestroyIfEmpty = true
	FirstAttackSouthWest.AutoDestroyIfEmpty = true
	FirstAttackSouth1.AutoDestroyIfEmpty = true
	FirstAttackSouth2.AutoDestroyIfEmpty = true

	start2ndSubChapter()

	-- fire signals
	start3rdSubChapter()

end
	
function end3rdChapter()
	
	if firstAttack ~= false then
		FirstAttackWest.AutoDestroyIfEmpty = true
		FirstAttackSouthWest.AutoDestroyIfEmpty = true
		FirstAttackSouth1.AutoDestroyIfEmpty = true
		FirstAttackSouth2.AutoDestroyIfEmpty = true
	end

	StartCutscene(Cutscenes[THRESHOLTWOCUTSCENE],start4thChapter)
		
end

------------------------------------------------------------------------------
-- final attack
------------------------------------------------------------------------------
function start4thChapter()
	
	WetterTurmEinfrieren()

	CreateArmyFinalAttack()
	
	if AllFireSignalsBurning == true then
	
		CreateArmyReinforcement()
	
	else

		DestroyNPCHermit()
		DestroyNPCJohannes()
		DestroyNPCFireSignal3()
		DestroyNPCRuins()
		DestroyNPCPrincess()
			
		GUIQuestTools.DisableQuestInformation()
			
		if NPCEastVillageBriefingShowNPCs ~= nil then
			ResolveBriefing(NPCEastVillageBriefingShowNPCs)
		end
			
	end

	CreateBriefingFinalAttack(AllFireSignalsBurning)

	CreateQuestSurviveFinalAttack()

	--CreateQuestShowLastAttackers()

end
function end4thChapter()

	StartCutscene(Cutscenes[MISSIONCOMPLETECUTSCENE],Victory)
	
end

------------------------------------------------------------------------------
-- build Bridge
------------------------------------------------------------------------------
function start1stSubChapter()

	CreateQuestBridge()

end
function end1stSubChapter()

	ResolveBriefing(NPCHeadquartersBriefingShowBridge)
	
end

------------------------------------------------------------------------------
-- destroy east Bridge
------------------------------------------------------------------------------
function start2ndSubChapter()

	CreateQuestDestroyEastBridge()

end
function end2ndSubChapter()

	if NPCEastVillageBriefingShowEastBridge ~= nil then
		ResolveBriefing(NPCEastVillageBriefingShowEastBridge)
	end
	
	-- stop respawn
	--StopArmyEastVillageAttackRespawn()
	
end

------------------------------------------------------------------------------
-- hermit npc
------------------------------------------------------------------------------
function start3rdSubChapter()
	
	GUIQuestTools.StartQuestInformation("Fire", "CM02_07_FleeOrFight/QI_signalFire", 1, 1)	

	GUIQuestTools.UpdateQuestInformationString("0/5")

	CreateNPCHermit()
	
end
function end3rdSubChapter()

	GUIQuestTools.UpdateQuestInformationString("1/5")

	start4thSubChapter()

end

------------------------------------------------------------------------------
-- johannes
------------------------------------------------------------------------------
function start4thSubChapter()

	CreateNPCJohannes()

end
function end4thSubChapter()

	GUIQuestTools.UpdateQuestInformationString("2/5")
	start5thSubChapter()

end

------------------------------------------------------------------------------
-- serf
------------------------------------------------------------------------------
function start5thSubChapter()

	CreateNPCFireSignal3()

end
function end5thSubChapter()

	GUIQuestTools.UpdateQuestInformationString("3/5")
	start6thSubChapter()

end

------------------------------------------------------------------------------
-- ruins
------------------------------------------------------------------------------
function start6thSubChapter()

	CreateNPCRuins()

end
function end6thSubChapter()
	
	GUIQuestTools.UpdateQuestInformationString("4/5")
	ResolveBriefing(NPCEastVillageBriefingShowNPCs)
	start7thSubChapter()

	--AllFireSignalsBurning = true
	
	--GUIQuestTools.DisableQuestInformation()
	

	--StartCutscene(Cutscenes[THRESHOLDONECUTSCENE])

end

function start7thSubChapter()
	local prinpos = GetPosition("princesspos")
	Logic.SetEntityName(Logic.CreateEntity(Entities.CU_Princess,prinpos.X,prinpos.Y,270,6),"P6_Princess_NPC")
	CreateNPCPrincess()
end

function end7thSubChapter()
	AllFireSignalsBurning = true
	
	GUIQuestTools.DisableQuestInformation()
	

	StartCutscene(Cutscenes[THRESHOLDONECUTSCENE])
end

--------------------------------------------------------------------------------------------------------------

function CreateNPCPrincess()
	-- setup table for npc
	NPCPrin			=	{}
	NPCPrin.name 		=	"P6_Princess_NPC"
	NPCPrin.callback	=	CreateNPCPrincessBriefing
	        
	-- create npc
	CreateNPC(NPCPrin)
	
	--FirstAttackWest.AutoDestroyIfEmpty = true
	--FirstAttackSouthWest.AutoDestroyIfEmpty = true
	--FirstAttackSouth1.AutoDestroyIfEmpty = true
	--FirstAttackSouth2.AutoDestroyIfEmpty = true
end

function CreateNPCPrincessBriefing()
	NPCPrinBriefing					=	{}
	NPCPrinBriefing.restoreCamera		=	true
	NPCPrinBriefing.finished			=	NPCPrinBriefingFinished

	local page = 0
	
	page = page +1
	
		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Mein König, seid Ihr das wirklich? Ihr seid zurück gekehrt! @cr Nach der Zerstörung meines Stadtteils hatte ich jede Hoffnung aufgegeben, jemals wieder ein freundliches Gesicht zu sehen! @cr Nie hätte ich gedacht, dass Ihr zurückkehren und diese - diese Monster zurückschlagen könntet!"
		
		NPCPrinBriefing[page].position 		=	GetPosition("P6_Princess_NPC")
		NPCPrinBriefing[page].dialogCamera		=	true
		
	page = page + 1
		
		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Aber nein. Was soll es schon für einen Unterschied machen? Ihr habt gesehen, was diese Ungeheuer mit meiner Stadt gemacht haben! @cr Wir haben evakuiert, wen wir konnten, doch so viele sind gestorben, hingeschlachtet ohne eine Spur von Gnade! @cr Ich konnte mich verstecken und so überleben. Dafür musste ich mit ansehen, wie sie alles vernichteten, was ich je gekannt habe."
		
		NPCPrinBriefing[page].position 		=	GetPosition("P6_Princess_NPC")
		NPCPrinBriefing[page].dialogCamera		=	true
		
		page = page + 1
		
		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Ich dachte, wenn ich weiter lebte und es schaffte, das Signalfeuer zu entfachen, dass vielleicht Hilfe käme. Doch wozu? Es gibt keine Rettung. @cr Nicht gegen das, was kommt. Ich habe gesehen, was sich nähert. Ein Sturm ist auf dem Weg. Sie werden kommen und jeden gefrorenen Grashalm in diesem Landstrich vernichten. @cr Warum sollte ich also mehr Menschen zu dieser Schlachtbank rufen? Wir sind verloren, verlassen. Es gibt keine Hoffnung."

		
		NPCPrinBriefing[page].position 		=	GetPosition("P6_Princess_NPC")
		NPCPrinBriefing[page].dialogCamera		=	true
	
	--	page 1
	
		page = page +1
	
		NPCPrinBriefing[page] 							= 	{}
		NPCPrinBriefing[page].mc						= 	{}
		NPCPrinBriefing[page].mc.title					= 	"Mentor"
		NPCPrinBriefing[page].mc.text					=	"Lasst eine große Messe lesen um den Menschen Mut zu geben! (100.000 Taler und ein voller Glaubensbalken)"
		
		NPCPrinBriefing[page].mc.firstText				=	"Hier bitte, ein Zeichen der Hoffnung! @cr In nomine partris et filii et spiritus sancti."
		NPCPrinBriefing[page].mc.firstSelectedCallback	=	NPCPrincessFirstSelected
	
		NPCPrinBriefing[page].mc.secondText			=	"Das kann ich gerade nicht zur Verfügung stellen."
		NPCPrinBriefing[page].mc.secondSelected		=	5
		
		NPCPrinBriefing[page].position 				=	GetPosition("P6_Princess_NPC")
		NPCPrinBriefing[page].dialogCamera				=	true

		NPCPrinBriefingMC								=	NPCPrinBriefing[page]
		

	--	page 2
	
		page = page +1
	
		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Keine Rettung. Keine Hoffnung. Alles ist verloren."
		
		NPCPrinBriefing[page].position 		=	GetPosition("P6_Princess_NPC")
		NPCPrinBriefing[page].dialogCamera		=	true
				
	--	page 4
		
		page = page +2
	
		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Die Glocken... ihr Läuten zieht sich durch die kalte Luft. Sie zeugen von Leben in dieser Stille der Zerstörung. Vielleicht gibt es Hoffnung. Ich werde das Feuer entzünden."
		
		NPCPrinBriefing[page].position 		=	GetPosition("FireSignalPos5")
		NPCPrinBriefing[page].explore 			=	1000

	--	page 6
	
		page = page +2

		NPCPrinBriefing[page] 					= 	{}
		NPCPrinBriefing[page].title			= 	"Prinzessin"
		NPCPrinBriefing[page].text				=	"Ich schätze eure Geste, glaubt mir. Doch nichts kann uns retten. Es ist vergebens."

		NPCPrinBriefing[page].position 		=	GetPosition("P6_Princess_NPC")
		
		StartBriefing(NPCPrinBriefing)
end

function NPCPrincessFirstSelected()
	if GetGold() >= 100000 and GetFaith() >= 5000 then
		AddGold(-100000)
		AddFaith(-1*Logic.GetPlayersGlobalResource( _playerId, ResourceType.Faith ))
		ReplaceEntity("FireSignalPos5", Entities.XD_SingnalFireOn)
		PlayerPayedForSignal5 = true
		ResolveBriefing(NPCFireSignal4BriefingShowFirePos54)
		return 7
	end
	return 9
end

function GetFaith(_playerId)

	if _playerId == nil then
		_playerId = GetHumanPlayer()
	end
	return Logic.GetPlayersGlobalResource( _playerId, ResourceType.Faith )
end

AddFaith = function(_playerId,_amount)
	if _amount == nil then
		_amount = _playerId
		_playerId = GetHumanPlayer()
		end
	Logic.AddToPlayersGlobalResource(_playerId,ResourceType.Faith,_amount)
	end
	
function NPCPrinBriefingFinished()
	if PlayerPayedForSignal5 ~= true then
			
		-- Reinit NPC
		CreateNPCPrincess()
	
	else
	
		end7thSubChapter()
	
	end
end

function DestroyNPCPrincess()
	if NPCPrin ~= nil and PlayerPayedForSignal5 ~= true then
	
		DestroyNPC(NPCPrin)
		
		if NPCFireSignal4BriefingShowFirePos54 ~= nil then
			ResolveBriefing(NPCFireSignal4BriefingShowFirePos54)
		end
		
	end
end

function createBombBriefing()
	BombRiderBriefing = {}
	BombRiderBriefing.finished = BombRiderBriefingFinished
	
	local page = 0
	page = page + 1
	
	BombRiderBriefing[page] = {}
	BombRiderBriefing[page].title = "Reiter"
	BombRiderBriefing[page].text = "Euer Gnaden! Wir sind froh, Euch wohlauf zu sehen! @cr Ich erstatte Bericht: Wir waren auf dem Weg, Euch zu verstärken als wir durch die Angreifer abgeschnitten wurden. @cr Es gelang uns allerdings, diese Position zu befestigen und uns dieser Wilden zu erwehren."
	BombRiderBriefing[page].position = GetPosition("bombriderNPC")
	page = page+1
	BombRiderBriefing[page] = {}
	BombRiderBriefing[page].title = "Reiter"
	BombRiderBriefing[page].text = "Wir verbleiben kampffähig und sind dankbar für unseren Entsatz! Mit eurer Erlaubnis unterstellen wir uns eurem Kommando! @cr Der Orden wird seinen Kampfeswillen und seine Hingabe zum Alten Reich im Blut all derer beweisen, die sein Volk bedrohen!"
	BombRiderBriefing[page].position = GetPosition("bombriderNPC")
	
	StartBriefing(BombRiderBriefing)
	
end

function BombRiderBriefingFinished()
	local tableID = Logic.ChangeEntityPlayerID(GetID("bombriderNPC"), 1)
	--Logic.SetSpeedFactor(tableID, 1.5)
	Logic.SetEntityInvulnerabilityFlag(tableID, 1)
	bombriders[tableID] = 40
	bobmersHP[tableID] = 500
	
	tableID = Logic.ChangeEntityPlayerID(GetID("bomber3"), 1)
	--Logic.SetSpeedFactor(tableID, 1.5)
	Logic.SetEntityInvulnerabilityFlag(tableID, 1)
	bombriders[tableID] = 40
	bobmersHP[tableID] = 500
	
	tableID = Logic.ChangeEntityPlayerID(GetID("bomber2"), 1)
	--Logic.SetSpeedFactor(tableID, 1.5)
	Logic.SetEntityInvulnerabilityFlag(tableID, 1)
	bombriders[tableID] = 40
	bobmersHP[tableID] = 500
end